﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using MicroRWD.Common;

namespace MicroRWD.UI.MFIC
{
    public partial class MicroRWD_MemoryPanel : UserControl
    {
        #region Constructor

        public MicroRWD_MemoryPanel()
        {
            InitializeComponent();

            // Load MicroRWD Memory Definitions
            microRWD_ListView.Items.Add(new ListViewItem(new string[] { "00", "Polling Delay (SLEEP / Power down) period" }));
            microRWD_ListView.Items.Add(new ListViewItem(new string[] { "01", "Aux data output" }));
            microRWD_ListView.Items.Add(new ListViewItem(new string[] { "02", "*Reserved* (Checksum)" }));
            microRWD_ListView.Items.Add(new ListViewItem(new string[] { "03", "Mifare/ICODE option byte" }));
            microRWD_ListView.Items.Add(new ListViewItem(new string[] { "04", "Wiegand parity option" }));
            microRWD_ListView.Items.Add(new ListViewItem(new string[] { "05", "Aux block address on card" }));
            microRWD_ListView.Items.Add(new ListViewItem(new string[] { "06", "Key no./type for read of aux data" }));
            microRWD_ListView.Items.Add(new ListViewItem(new string[] { "07", "Beep delay parameter (x40mS)" }));
            microRWD_ListView.Items.Add(new ListViewItem(new string[] { "08", "Aux output source data selection." }));
            microRWD_ListView.Items.Add(new ListViewItem(new string[] { "09", "Aux out (serial data) redirection" }));
            microRWD_ListView.Items.Add(new ListViewItem(new string[] { "0A", "Aux output serial format (Hex or ASCII)" }));
            microRWD_ListView.Items.Add(new ListViewItem(new string[] { "0B", "Aux output byte order option" }));

            // Authorized cards list
            for ( UInt16 i = 0x000C; i <= 0x00FF; i += 4 )
            {
                microRWD_ListView.Items.Add(new ListViewItem(new string[] { (i + 0).ToString("X2"), "Card " + i.ToString() + " (MS byte)" }));
                microRWD_ListView.Items.Add(new ListViewItem(new string[] { (i + 1).ToString("X2"), "Card " + i.ToString() + " (Byte 2)" }));
                microRWD_ListView.Items.Add(new ListViewItem(new string[] { (i + 2).ToString("X2"), "Card " + i.ToString() + " (Byte 1)" }));
                microRWD_ListView.Items.Add(new ListViewItem(new string[] { (i + 3).ToString("X2"), "Card " + i.ToString() + " (LS byte)" }));
            }

            // Select first item by default
            microRWD_ListView.Items[0].Selected = true;
        }

        #endregion


        #region Event Handlers

        private void writeToMicroRWD_Button_Click(object sender, EventArgs e)
        {
            writeToMicroRWD();
        }

        private void microRWD_ListView_DoubleClick(object sender, EventArgs e)
        {
            writeToMicroRWD();
        }

        private void writeToMicroRWD()
        {
            // Establish memory location
            if (microRWD_ListView.SelectedIndices.Count > 0)
            {
                WriteToMicroRWD_MemoryForm form = new WriteToMicroRWD_MemoryForm(1, microRWD_ListView, 1, Program.Controller.Reader);
                form.ShowDialog();
            }
        }

        private void microRWD_ListView_SelectedIndexChanged(object sender, EventArgs e)
        {
            // Check for selected index
            if (microRWD_ListView.SelectedIndices.Count > 0)
            {
                // Ensure selected item is visible
                microRWD_ListView.EnsureVisible(microRWD_ListView.SelectedIndices[0]);
            }
        }

        #endregion

    }
}
